"""
Creating a Homogeneous Offshore Map
===================================

For offshore wind resource assessments, it is often necessary to create a "trivial" map with zero elevation and constant roughness. This cell demonstrates creating such a map from scratch using a bounding box, converting it to a raster, and generating the corresponding polygon representation.
"""

import windkit as wk

bbox = wk.spatial.BBox.utm_bbox_from_geographic_coordinate(7, 55, 20000)
offshore_elev = wk.create_vector_map(bbox=bbox, elevation=0)
offshore_rou = wk.create_vector_map(
    bbox=bbox, map_type="roughness", roughness_change=(0.0, 0.0)
)
z0 = wk.lines_to_polygons(offshore_rou)
wk.plot.landcover_map(z0, "z0")
