"""
BWC to WWC
====================

This example demonstrates how to convert a binned wind climate (BWC) object
to a weibull wind climate (WWC) object using the :py:func:`weibull_fit` function from the
:ref:`windkit` library.

"""

# %%
# Get Sample Data
# ------------------------
# First, we fetch some sample data from the Serra Santa Luzia case.

import windkit as wk

ssl = wk.load_tutorial_data("serra_santa_luzia")
bwc = ssl.bwc

print(bwc)

# %%
# Convert BWC to WWC
# ------------------------
# Now, we can convert the binned wind climate (BWC) object to a weibull wind climate (WWC) object

wwc = wk.weibull_fit(bwc)
print(wwc)
